#ifndef _SCHED_H_
#define _SCHED_H_

#include <toykernel/types.h>
#include <arch/processor.h>
#include <arch/desc.h>
#include <arch/pgtable.h>
#include <arch/current.h>

struct task_struct {
	volatile long state;	/* -1 unrunnable, 0 runnable, >0 stopped */
	struct task_struct *next_task, *prev_task;
	/* If NULL, default_ldt is used */
	struct desc_struct *ldt;
	/* tss for this task */
	struct tss_struct tss;
};

#define INIT_TSS \
{ \
	0, 0,										/* back_link, __blh */		\
	sizeof(init_stack) + (long) &init_stack,	/* esp0 */					\
	__KERNEL_DS, 0,								/* ss0 */					\
	0, 0, 0, 0, 0, 0,							/* stack1, stack2 */		\
	(long) &swapper_pg_dir,						/* cr3 */					\
	0, 0,										/* eip, eflags */			\
	0, 0, 0, 0,									/* eax, ecx, edx, ebx */	\
	0, 0, 0, 0,									/* esp, ebp, esi, edi */	\
	__USER_DS, 0, __USER_DS, 0, __USER_DS, 0,	/* es, cs, ss */			\
	__USER_DS, 0, __USER_DS, 0, __USER_DS, 0,	/* ds, fs, gs */			\
	__LDT(0), 0,								/* ldt */					\
	0, 0x8000,									/* trace, bitmap */			\
	{~0, },										/* ioperm */				\
	__TSS(0),									/* tr */					\
	0,											/* cr2 */					\
	0,											/* trap_no */				\
	0,											/* error_code */			\
	{ { 0, }, }									/* 387 state */				\
} 

#define INIT_TASK(tsk) 										\
{ 															\
    state:				0,									\
    next_task:			&tsk,								\
    prev_task:			&tsk,								\
	ldt:				NULL,								\
	tss:				INIT_TSS							\
}

#ifndef INIT_TASK_SIZE
# define INIT_TASK_SIZE	2048*sizeof(long)
#endif

union task_union {
	struct task_struct task;
	unsigned long stack[INIT_TASK_SIZE/sizeof(long)];
};

extern union task_union init_task_union;

#endif
