#ifndef _SCHED_H_
#define _SCHED_H_

struct task_struct {
	volatile long state;	/* -1 unrunnable, 0 runnable, >0 stopped */
	struct task_struct *next_task, *prev_task;
};

/*
 *  INIT_TASK is used to set up the first task table, touch at
 * your own risk!. Base=0, limit=0x1fffff (=2MB)
 */
/*
#define INIT_TASK(tsk)										\
{															\
    state:				0,									\
    flags:				0,									\
    sigpending:			0,									\
    addr_limit:			KERNEL_DS,							\
    exec_domain:		&default_exec_domain,				\
    lock_depth:			-1,									\
    counter:			DEF_COUNTER,						\
    nice:				DEF_NICE,							\
    policy:				SCHED_OTHER,						\
    mm:					NULL,								\
    active_mm:			&init_mm,							\
    cpus_runnable:		-1,									\
    cpus_allowed:		-1,									\
    run_list:			LIST_HEAD_INIT(tsk.run_list),		\
    next_task:			&tsk,								\
    prev_task:			&tsk,								\
    p_opptr:			&tsk,								\
    p_pptr:				&tsk,								\
    thread_group:		LIST_HEAD_INIT(tsk.thread_group),	\
    wait_chldexit:		__WAIT_QUEUE_HEAD_INITIALIZER(tsk.wait_chldexit),\
    real_timer:			{									\
	function:			it_real_fn							\
    },														\
    cap_effective:		CAP_INIT_EFF_SET,					\
    cap_inheritable:	CAP_INIT_INH_SET,					\
    cap_permitted:		CAP_FULL_SET,						\
    keep_capabilities:	0,									\
    rlim:				INIT_RLIMITS,						\
    user:				INIT_USER,							\
    comm:				"swapper",							\
    thread:				INIT_THREAD,						\
    fs:					&init_fs,							\
    files:				&init_files,						\
    sigmask_lock:		SPIN_LOCK_UNLOCKED,					\
    sig:				&init_signals,						\
    pending:			{ NULL, &tsk.pending.head, {{0}}},	\
    blocked:			{{0}},								\
    alloc_lock:			SPIN_LOCK_UNLOCKED,					\
    journal_info:		NULL,								\
}
*/
#define INIT_TASK(tsk) 										\
{ 															\
    state:				0,									\
    next_task:			&tsk,								\
    prev_task:			&tsk,								\
}

#ifndef INIT_TASK_SIZE
# define INIT_TASK_SIZE	2048*sizeof(long)
#endif

union task_union {
	struct task_struct task;
	unsigned long stack[INIT_TASK_SIZE/sizeof(long)];
};

extern union task_union init_task_union;

#endif
