#!/bin/sh

archs="386 486 586 686 PENTIUMIII P4 K7"

echo "#ifndef _AUTOCONF_H_" > include/toykernel/autoconf.h
echo "#define _AUTOCONF_H_" >> include/toykernel/autoconf.h
echo " " >> include/toykernel/autoconf.h
for a in $archs
do
	if [ $1 == $a ]; then
		echo "#define CONFIG_M"$a" 1" >> include/toykernel/autoconf.h
		case $a in
			"386" | "486")
				echo "#define CONFIG_X86_L1_CACHE_SHIFT (4)" >> include/toykernel/autoconf.h ;;
			"586" | "686" | "PENTIUMIII")
				echo "#define CONFIG_X86_L1_CACHE_SHIFT (5)" >> include/toykernel/autoconf.h ;;
			"P4")
				echo "#define CONFIG_X86_L1_CACHE_SHIFT (7)" >> include/toykernel/autoconf.h ;;
			"K7")
				echo "#define CONFIG_X86_L1_CACHE_SHIFT (6)" >> include/toykernel/autoconf.h ;;
		esac
	else
		echo "#undef CONFIG_M"$a >> include/toykernel/autoconf.h
	fi
done
echo " " >> include/toykernel/autoconf.h
echo "#endif" >> include/toykernel/autoconf.h
