/*
 * $Id: sched.c,v 1.1.1.1 2002/09/19 00:37:09 halite Exp $
 */

#include <toykernel/kernel.h>
#include <toykernel/sched.h>
#include <toykernel/kernel_stat.h>
#include <toykernel/init.h>
#include <toykernel/mm.h>
#include <toykernel/unistd.h>
#include <arch/system.h>

#if HZ < 200
#define TICK_SCALE(x)	((x) >> 2)
#elif HZ < 400
#define TICK_SCALE(x)	((x) >> 1)
#elif HZ < 800
#define TICK_SCALE(x)	(x)
#elif HZ < 1600
#define TICK_SCALE(x)	((x) << 1)
#else
#define TICK_SCALE(x)	((x) << 2)
#endif

#define NICE_TO_TICKS(nice)	(TICK_SCALE(20-(nice))+1)

struct task_struct * init_tasks[NR_CPUS] = {&init_task, };
struct kernel_stat kstat;
static LIST_HEAD(runqueue_head);

#ifdef CONFIG_SMP

#define idle_task(cpu) (init_tasks[cpu_number_map(cpu)])
#define can_schedule(p,cpu) \
	((p)->cpus_runnable & (p)->cpus_allowed & (1 << cpu))

#else

#define idle_task(cpu) (&init_task)
#define can_schedule(p,cpu) (1)

#endif

/*
 * This is the function that decides how desirable a process is..
 * You can weigh different processes against each other depending
 * on what CPU they've run on lately etc to try to handle cache
 * and TLB miss penalties.
 *
 * Return values:
 *	 -1000: never select this
 *	     0: out of time, recalculate counters (but it might still be
 *		selected)
 *	   +ve: "goodness" value (the larger, the better)
 *	 +1000: realtime process, select this.
 */

static inline int goodness(struct task_struct * p, int this_cpu)/*, struct mm_struct *this_mm)*/
{
	int weight;

	/*
	 * select the current process after every other
	 * runnable process, but before the idle thread.
	 * Also, dont trigger a counter recalculation.
	 */
	weight = -1;
	if (p->policy & SCHED_YIELD)
		goto out;

	/*
	 * Non-RT process - normal case first.
	 */
	if (p->policy == SCHED_OTHER) {
		/*
		 * Give the process a first-approximation goodness value
		 * according to the number of clock-ticks it has left.
		 *
		 * Don't do any other calculations if the time slice is
		 * over..
		 */
		weight = p->counter;
		if (!weight)
			goto out;
			
#ifdef CONFIG_SMP
		/* Give a largish advantage to the same processor...   */
		/* (this is equivalent to penalizing other processors) */
		if (p->processor == this_cpu)
			weight += PROC_CHANGE_PENALTY;
#endif

#if 0
		/* .. and a slight advantage to the current MM */
		if (p->mm == this_mm || !p->mm)
			weight += 1;
#endif
		weight += 20 - p->nice;
		goto out;
	}

	/*
	 * Realtime process, select the first one on the
	 * runqueue (taking priorities within processes
	 * into account).
	 */
	weight = 1000;/* + p->rt_priority;*/
out:
	return weight;
}

/*
 * Careful!
 *
 * This has to add the process to the _beginning_ of the
 * run-queue, not the end. See the comment about "This is
 * subtle" in the scheduler proper..
 */
static inline void add_to_runqueue(struct task_struct * p)
{
	list_add(&p->run_list, &runqueue_head);
	nr_running++;
}

static inline void move_last_runqueue(struct task_struct * p)
{
	list_del(&p->run_list);
	list_add_tail(&p->run_list, &runqueue_head);
}

static inline void move_first_runqueue(struct task_struct * p)
{
	list_del(&p->run_list);
	list_add(&p->run_list, &runqueue_head);
}

/*
 * Wake up a process. Put it on the run-queue if it's not
 * already there.  The "current" process is always on the
 * run-queue (except when the actual re-schedule is in
 * progress), and as such you're allowed to do the simpler
 * "current->state = TASK_RUNNING" to mark yourself runnable
 * without the overhead of this.
 */
static inline int try_to_wake_up(struct task_struct * p, int synchronous)
{
	unsigned long flags;
	int success = 0;

	/*
	 * We want the common case fall through straight, thus the goto.
	 */
//	spin_lock_irqsave(&runqueue_lock, flags);
	p->state = TASK_RUNNING;
	if (task_on_runqueue(p))
		goto out;
	add_to_runqueue(p);
//	if (!synchronous || !(p->cpus_allowed & (1 << smp_processor_id())))
//		reschedule_idle(p);
	success = 1;
out:
//	spin_unlock_irqrestore(&runqueue_lock, flags);
	return success;
}

inline int wake_up_process(struct task_struct * p)
{
	return try_to_wake_up(p, 0);
}

/*
 * schedule_tail() is getting called from the fork return path. This
 * cleans up all remaining scheduler things, without impacting the
 * common case.
 */
static inline void __schedule_tail(struct task_struct *prev)
{
	prev->policy &= ~SCHED_YIELD;
}

asmlinkage void schedule_tail(struct task_struct *prev)
{
	__schedule_tail(prev);
}

asmlinkage void schedule(void)
{
	struct task_struct *prev, *next, *p;
	struct list_head *tmp;
	int this_cpu, c;

need_resched_back:
	this_cpu = 0; /*prev->processor()*/
	prev = current;
	
	/* move an exhausted RR process to be last.. */
	if (unlikely(prev->policy == SCHED_RR))
		if (!prev->counter) {
			prev->counter = NICE_TO_TICKS(prev->nice);
			move_last_runqueue(prev);
		}

#if 0
	switch (prev->state) {
		case TASK_INTERRUPTIBLE:
			if (signal_pending(prev)) {
				prev->state = TASK_RUNNING;
				break;
			}
		default:
			del_from_runqueue(prev);
		case TASK_RUNNING:;
	}
#endif
	prev->need_resched = 0;

	/*
	 * this is the scheduler proper:
	 */

repeat_schedule:
	/*
	 * Default process to select..
	 */
#if 0
	next = idle_task(this_cpu);
	c = -1000;
	list_for_each(tmp, &runqueue_head) {
		p = list_entry(tmp, struct task_struct, run_list);
		if (can_schedule(p, this_cpu)) {
			int weight = goodness(p, this_cpu);/*, prev->active_mm);*/
			if (weight > c)
				c = weight, next = p;
		}
	}
#else
	next = current->next_task;
#endif

	/* Do we need to re-calculate counters? */
	if (unlikely(!c)) {
		struct task_struct *p;

//		spin_unlock_irq(&runqueue_lock);
//		read_lock(&tasklist_lock);
		for_each_task(p)
			p->counter = (p->counter >> 1) + NICE_TO_TICKS(p->nice);
//		read_unlock(&tasklist_lock);
//		spin_lock_irq(&runqueue_lock);
		goto repeat_schedule;
	}

	/*
	 * from this point on nothing can prevent us from
	 * switching to the next task, save this fact in
	 * sched_data.
	 */
//	sched_data->curr = next;
//	task_set_cpu(next, this_cpu);
//	spin_unlock_irq(&runqueue_lock);

	if (unlikely(prev == next)) {
		/* We won't go through the normal tail, so do this by hand */
		prev->policy &= ~SCHED_YIELD;
		goto same_process;
	}

	kstat.context_swtch++;
	/*
	 * there are 3 processes which are affected by a context switch:
	 *
	 * prev == .... ==> (last => next)
	 *
	 * It's the 'much more previous' 'prev' that is on next's stack,
	 * but prev is set to (the just run) 'last' process by switch_to().
	 * This might sound slightly confusing but makes tons of sense.
	 */
	prepare_to_switch();
#if 0
	{
		struct mm_struct *mm = next->mm;
		struct mm_struct *oldmm = prev->active_mm;
		if (!mm) {
			BUG_ON(next->active_mm);
			next->active_mm = oldmm;
			atomic_inc(&oldmm->mm_count);
			enter_lazy_tlb(oldmm, next, this_cpu);
		} else {
			BUG_ON(next->active_mm != mm);
			switch_mm(oldmm, mm, next, this_cpu);
		}

		if (!prev->mm) {
			prev->active_mm = NULL;
			mmdrop(oldmm);
		}
	}
#endif

	/*
	 * This just switches the register state and the
	 * stack.
	 */
	switch_to(prev, next, prev);
	__schedule_tail(prev);

same_process:
//	reacquire_kernel_lock(current);
	if (current->need_resched)
		goto need_resched_back;
	return;
}

#define move_to_user_mode() \
__asm__ __volatile__ ("movl %%esp,%%eax\n\t" \
	"pushl %0\n\t" \
	"pushl %%eax\n\t" \
	"pushfl\n\t" \
	"pushl %1\n\t" \
	"pushl $1f\n\t" \
	"iret\n" \
	"1:\tmovl %0,%%eax\n\t" \
	"mov %%ax,%%ds\n\t" \
	"mov %%ax,%%es\n\t" \
	"mov %%ax,%%fs\n\t" \
	"mov %%ax,%%gs" \
	: /* no outputs */ :"i" (__USER_DS), "i" (__USER_CS):"ax")

static void t1_f(void)
{
	static int cnt = 0;
	sti();
	printk("t1 : %d\r", cnt++);
	for (;;)
		printk("t1");
}
static void t2_f(void)
{
	static int cnt = 0;
	sti();
	printk("t2 : %d\r", cnt--);
	for (;;)
		printk("t2");
}

static inline int fork(void)
{
	int retval;

	asm (
		"int	$0x80\n\t"
		: "=&a" (retval)
		: "0" (__NR_fork)
		: "memory");
	return retval;
}

void __init sched_init(void)
{
#if 0	
	unsigned long *tmp;
	union task_union *t1, *t2;

	tmp = (unsigned long *) __get_free_pages(0, 8192);
	if ((unsigned long)tmp != ((unsigned long)tmp & (~(8191UL))))
			tmp = (unsigned long *) __get_free_pages(0, PAGE_SIZE);
	t1 = (union task_union *) __get_free_pages(0, 8192);
	t2 = (union task_union *) __get_free_pages(0, 8192);

	t1->task.state = 0;
	t1->task.need_resched = 0;
	t1->task.counter = 20;
	t1->task.policy = SCHED_OTHER;
	t1->task.next_task = &t2->task;
	t1->task.prev_task = &init_task;
	t1->task.pid = 1;
	list_add(&t1->task.run_list, &runqueue_head);
	tmp = (unsigned long *)((char *)t1 + 8192);
	*(--tmp) = 0; /* eflags */
	*(--tmp) = __KERNEL_CS;
	*(--tmp) = (unsigned long)t1_f; /* eip */
	*(--tmp) = (unsigned long)t1_f;
	*(--tmp) = 0;
	*(--tmp) = 0;
	*(--tmp) = 0;
	t1->task.thread.esp0 = (unsigned long)tmp;
	t1->task.thread.eip = (unsigned long)t1_f;
	t1->task.thread.esp = t1->task.thread.esp0;
	t1->task.thread.fs = __KERNEL_DS;
	t1->task.thread.gs = __KERNEL_DS;
	
	t2->task.state = 0;
	t2->task.need_resched = 0;
	t2->task.counter = 20;
	t2->task.policy = SCHED_OTHER;
	t2->task.next_task = &t1->task;
	t2->task.prev_task = &t1->task;
	t2->task.pid = 2;
	list_add(&t2->task.run_list, &runqueue_head);
	tmp = (unsigned long *)((char *)t2 + 8192);
	*(--tmp) = 0; /* eflags */
	*(--tmp) = __KERNEL_CS;
	*(--tmp) = (unsigned long)t2_f; /* eip */
	*(--tmp) = (unsigned long)t2_f;
	*(--tmp) = 0;
	*(--tmp) = 0;
	*(--tmp) = 0;
	t2->task.thread.esp0 = (unsigned long)tmp;
	t2->task.thread.eip = (unsigned long)t2_f;
	t2->task.thread.esp = t2->task.thread.esp0;
	t2->task.thread.fs = __KERNEL_DS;
	t2->task.thread.gs = __KERNEL_DS;

	init_task.next_task = &t1->task;
	init_task.prev_task = &t2->task;

printk("c=%x, t1=%x, t2=%x, esp1=%x, esp2=%x\n", current, t1, t2, t1->task.thread.esp0, t2->task.thread.esp0);
#endif

	int id;

	id = fork();
	printk("sched : id=%d\n", id);
	if (!id)
	{
		sti();
		while (1)
		{
			static int cnt = 0;
			printk("t1 : %d\n", cnt++);
		}
	}
	else
	{
		id = fork();
		printk("sched : id=%d\n", id);
		if (!id)
		{
			sti();
			while (1)
			{
				static int cnt = -1;
				printk ("t2 : %d\n", cnt--);
			}
		}
	}
	//current->need_resched = 1;
}

void test_printk(unsigned long a, unsigned long b)
{
	printk("tp : %x, %x     \n", a, b);
}

